"""
eval.py:

This script is used to evaluate an expression and assign its result to a
given SPICE variable.

The syntax of the command is:

eval.py spice_variable_name eval_string

Example:

eval.py "test1" "sin(3.0)"

assign the result of sin(3.0) to the SPICE variable test1

"""

from math import *
import cmath
import string
import fractions
import sys
import re
import os
import os.path
import logging
import decimal
import datetime
import time
import re
import random


import PySpice

# print "Arguments: {num}".format(num=len(sys.argv))

if len(sys.argv) != 1:
    raise ValueError, "The eval script requires no arguments"

# test = str(PySpice.getuservar("eval_string")))
eval_string ='{eval_str}'.format(eval_str=str(PySpice.getuservar("__spice__eval__in")))

# print 'User variable [{eval_str}]\n'.format(eval_str=str(PySpice.getuservar("eval_string")))

try:
	eval_result = eval(eval_string)
except:
	eval_result = eval_string


eval_result_string = str(eval_result)
	
# print 'Evaluating [{eval_str}]. Result: {result}\n'.format(eval_str=eval_string, result=eval_result_string)

eval_string ='{eval_str}'.format(eval_str=str(PySpice.setuservar("__spice__eval__out", eval_result_string, False)))





